<?php return array (
  'author.editPublishedDisabled' => 'The authors of this publication can not be edited because it has already been published.',
  'author.publicationNotFound' => 'The publication for this author could not be found.',
  'author.submit.submissionCitations' => 'Provide a formatted list of references for works cited in this submission. Please separate individual references with a blank line.',
  'author.submission.roundStatus.reviewsReady' => 'New reviews have been submitted and are being considered by the editor.',
  'author.submission.roundStatus.reviewOverdue' => 'One or more reviewers missed their deadline. The editorial team has been notified and will take action to ensure reviews are completed. You do not need to take any action at this time. You will be notified when a decision has been made.',
  'submission.confirm.message' => 'Your submission has been uploaded and is ready to be sent. You may go back to review and adjust any of the information you have entered before continuing. When you are ready, click "Finish Submission".',
  'submission.submit.availableUserGroups' => 'Submit As',
  'submission.submit.availableUserGroupsDescription' => 'Select the role that best describes your contribution to this submission.',
  'submission.submit.contactConsent' => 'Corresponding Contact',
  'submission.submit.contactConsentDescription' => 'Yes, I would like to be contacted about this submission.',
  'submission.submit.userGroupDescriptionManagers' => 'Submit in any of the following roles if you would like to be able to edit and publish this submission yourself: {$managerGroups}',
  'submission.submit.submissionChecklist' => 'Submission Requirements',
  'submission.submit.submissionChecklistDescription' => 'You must read and acknowledge that you\'ve completed the requirements below before proceeding.',
  'submission.submit.submissionComplete' => 'Submission complete',
  'submission.submit.submissionCompleteThanks' => 'Thank you for your interest in publishing with {$contextName}.',
  'submission.submit.copyrightNoticeAgreementLabel' => 'Acknowledge the copyright statement',
  'submission.submit.copyrightNoticeAgree' => 'Yes, I agree to abide by the terms of the copyright statement.',
  'submission.submit.genre.label' => 'What kind of file is this?',
  'submission.submit.genre.description' => 'Choose the option that best describes this file.',
  'submission.submit.genre.error' => 'Please select the kind of file for each upload.',
  'submission.submit.removeConfirm' => 'Are you sure you want to remove this file?',
  'submission.submit.whatNext' => 'What Happens Next?',
  'submission.submit.whatNext.forNow' => 'For now, you can:',
  'submission.submit.whatNext.review' => 'Review this submission',
  'submission.submit.whatNext.create' => 'Create a new submission',
  'submission.submit.whatNext.return' => 'Return to your dashboard',
  'submission.submit.extendedMetadata' => 'Extended Metadata',
  'metadata.filters.crossref.settings.email.displayName' => 'CrossRef Registration Email',
  'metadata.filters.crossref.settings.email.validationMessage' => 'Please enter a valid CrossRef registration email. You can register your email for free on the CrossRef web site.',
  'metadata.filters.isbndb.settings.apiKey.displayName' => 'ISBNdb API Key',
  'metadata.filters.isbndb.settings.apiKey.validationMessage' => 'Please enter your ISBNdb API key. If you don\'t have a key yet you can request one for free from the ISBNdb project.',
  'metadata.filters.pubmed.settings.email.displayName' => 'PubMed Registration Email',
  'metadata.filters.pubmed.settings.email.validationMessage' => 'Please enter a valid PubMed registration email if you have one.',
  'metadata.filters.worldcat.settings.apiKey.displayName' => 'WorldCat API Key',
  'metadata.filters.worldcat.settings.apiKey.validationMessage' => 'Please enter a valid WorldCat API key if you have one.',
  'metadata.filters.paracite.settings.citationModule.displayName' => 'Citation Module',
  'metadata.filters.paracite.settings.citationModule.validationMessage' => 'Please select one of the given citation modules.',
  'metadata.filters.settings.isOptional.displayName' => 'Don\'t use by default (will still be available to the editor)',
  'metadata.filters.settings.isOptional.validationMessage' => 'Internal error. A non-valid value has been posted for the \'optional filter\' setting. Please report this as a bug.',
  'metadata.property.displayName.author' => 'Authors',
  'metadata.property.validationMessage.author' => 'For best results, authors should be entered in the following format: Coleman Jr, D. (Ralf) Dr.',
  'metadata.property.displayName.editor' => 'Editors',
  'metadata.property.validationMessage.editor' => 'For best results, editors should be entered in the following format: Coleman Jr, D. (Ralf) Dr.',
  'metadata.property.displayName.article-title' => 'Article/Paper Title',
  'metadata.property.validationMessage.article-title' => 'Please enter a valid article/paper title.',
  'metadata.property.displayName.source' => 'Publication Title',
  'metadata.property.validationMessage.source' => 'Please enter a valid publication title.',
  'metadata.property.displayName.date' => 'Publication Date',
  'metadata.property.validationMessage.date' => 'Please enter a valid publication date (format: YYYY-MM-DD).',
  'metadata.property.displayName.access-date' => 'Access Date',
  'metadata.property.validationMessage.access-date' => 'Please enter a valid access date (format: YYYY-MM-DD).',
  'metadata.property.displayName.issue' => 'Issue',
  'metadata.property.validationMessage.issue' => 'Please enter a valid issue.',
  'metadata.property.displayName.volume' => 'Volume',
  'metadata.property.validationMessage.volume' => 'Please enter a valid volume.',
  'metadata.property.displayName.season' => 'Season',
  'metadata.property.validationMessage.season' => 'Please enter a valid season identifier.',
  'metadata.property.displayName.chapter-title' => 'Chapter Title',
  'metadata.property.validationMessage.chapter-title' => 'Please enter a valid chapter title.',
  'metadata.property.displayName.edition' => 'Edition',
  'metadata.property.validationMessage.edition' => 'Please enter a valid edition.',
  'metadata.property.displayName.series' => 'Series',
  'metadata.property.validationMessage.series' => 'Please enter a valid series.',
  'metadata.property.displayName.supplement' => 'Supplement',
  'metadata.property.validationMessage.supplement' => 'Please enter a valid supplement.',
  'metadata.property.displayName.conf-date' => 'Conference Date',
  'metadata.property.validationMessage.conf-date' => 'Please enter a valid conference date (format: YYYY-MM-DD).',
  'metadata.property.displayName.conf-loc' => 'Conference Location',
  'metadata.property.validationMessage.conf-loc' => 'Please enter a valid conference location.',
  'metadata.property.displayName.conf-name' => 'Conference Name',
  'metadata.property.validationMessage.conf-name' => 'Please enter a valid conference name.',
  'metadata.property.displayName.conf-sponsor' => 'Conference Sponsor',
  'metadata.property.validationMessage.conf-sponsor' => 'Please enter a valid conference sponsor.',
  'metadata.property.displayName.institution' => 'Institution',
  'metadata.property.validationMessage.institution' => 'Please enter a valid institution.',
  'metadata.property.displayName.fpage' => 'First Page',
  'metadata.property.validationMessage.fpage' => 'Please enter a valid first page (must be a numeric value).',
  'metadata.property.displayName.lpage' => 'Last Page',
  'metadata.property.validationMessage.lpage' => 'Please enter a valid last page (must be a numeric value).',
  'metadata.property.displayName.size' => 'Number of Pages',
  'metadata.property.validationMessage.size' => 'Please enter a valid total number of pages (must be a numeric value).',
  'metadata.property.displayName.publisher-loc' => 'Publisher Location',
  'metadata.property.validationMessage.publisher-loc' => 'Please enter a valid publisher location.',
  'metadata.property.displayName.publisher-name' => 'Publisher Name',
  'metadata.property.validationMessage.publisher-name' => 'Please enter a valid publisher name.',
  'metadata.property.displayName.isbn' => 'ISBN',
  'metadata.property.validationMessage.isbn' => 'Please enter a valid ISBN (9 or 13 numbers).',
  'metadata.property.displayName.issn' => 'Print ISSN',
  'metadata.property.validationMessage.issn' => 'Please enter a valid Print ISSN.',
  'metadata.property.displayName.eissn' => 'eISSN',
  'metadata.property.validationMessage.eissn' => 'Please enter a valid eISSN.',
  'metadata.property.displayName.doi' => 'DOI',
  'metadata.property.validationMessage.doi' => 'Please enter a valid DOI.',
  'metadata.property.displayName.publisher-id' => 'Custom Publication ID',
  'metadata.property.validationMessage.publisher-id' => 'Please enter a valid custom publication ID.',
  'metadata.property.displayName.coden' => 'CODEN',
  'metadata.property.validationMessage.coden' => 'Please enter a valid CODEN.',
  'metadata.property.displayName.sici' => 'SICI',
  'metadata.property.validationMessage.sici' => 'Please enter a valid SICI.',
  'metadata.property.displayName.pmid' => 'PMID',
  'metadata.property.validationMessage.pmid' => 'Please enter a valid PMID.',
  'metadata.property.displayName.uri' => 'Link to the Publication',
  'metadata.property.validationMessage.uri' => 'Please enter a valid alternative link to the publication.',
  'metadata.property.displayName.comment' => 'Comment',
  'metadata.property.validationMessage.comment' => 'Please enter a valid comment.',
  'metadata.property.displayName.annotation' => 'Annotation',
  'metadata.property.validationMessage.annotation' => 'Please enter a valid annotation.',
  'metadata.property.displayName.publication-type' => 'Publication Type',
  'metadata.property.validationMessage.publication-type' => 'Please make sure that you always set a publication type. Currently supported values are book (for books or book chapters) and journal (for journal articles). Otherwise the citation output formatting will not work correctly.',
  'metadata.property.displayName.title-type' => 'Title Type',
  'metadata.property.validationMessage.title-type' => 'Please make sure that you set a valid title type. Supported values are \'abbreviated\', \'translated\', \'alternative\' and \'uniform\'.',
  'metadata.property.displayName.nonSort' => 'Part of title ignored while sorting',
  'metadata.property.validationMessage.nonSort' => 'Please only enter the initial characters of the title that should be ignored when sorting the title.',
  'metadata.property.displayName.title' => 'Title',
  'metadata.property.validationMessage.title' => 'Please enter a valid title.',
  'metadata.property.displayName.subTitle' => 'Subtitle',
  'metadata.property.validationMessage.subTitle' => 'Please enter a valid subtitle.',
  'metadata.property.displayName.partNumber' => 'Part Number',
  'metadata.property.validationMessage.partNumber' => 'Please enter a valid part number.',
  'metadata.property.displayName.partName' => 'Part Name',
  'metadata.property.validationMessage.partName' => 'Please enter a valid part name.',
  'metadata.property.displayName.name-type' => 'Name Type',
  'metadata.property.validationMessage.name-type' => 'Please make sure that you set a valid name type. Supported values are \'personal\', \'corporate\' and \'conference\'.',
  'metadata.property.displayName.abstract' => 'Abstract',
  'common.queue.long.submissionsUnassigned' => 'Unassigned',
  'common.queue.long.myAssigned' => 'My Assigned',
  'common.queue.long.submissionsArchived' => 'Archived Submissions',
  'submission.authors' => 'Authors',
  'submission.authorBiography' => 'Author Biography',
  'submission.authorBiographies' => 'Author Biographies',
  'submission.authorWithAffiliation' => '{$name}, {$affiliation}',
  'submission.shortAuthor' => '{$author} et al.',
  'submission.representationOfTitle' => '{$representation} of {$title}',
  'submission.mySubmissions' => 'My Authored',
  'submission.addFile' => 'Upload File',
  'submission.additionalFiles' => 'Additional Files',
  'submission.agencies' => 'Agencies',
  'submission.abstractViews' => 'Abstract Views',
  'submission.accepted' => 'Accepted',
  'submission.acknowledge' => 'Acknowledge',
  'submission.ask' => 'Ask',
  'submission.attachedFile' => 'Attached file',
  'submission.backToSubmissionEditing' => 'Back to Submission Editing',
  'submission.changeComments' => 'Change to',
  'submission.changeFile' => 'Change File',
  'submission.citations' => 'References',
  'submission.citations.description' => 'Enter each reference on a new line so that they can be extracted and recorded separately.',
  'submission.parsedCitations' => 'Extracted References',
  'submission.parsedCitations.DOI' => 'DOI',
  'submission.parsedCitations.description' => 'The following references have been extracted and will be linked to the submission metadata.',
  'submission.parsedAndSaveCitations' => 'Extract and Save References',
  'submission.comments.addComment' => 'Add Comment',
  'submission.comments.comments' => 'Comments',
  'submission.comments.confirmDelete' => 'Are you sure you would like to delete this comment?',
  'submission.comments.corrections' => 'Corrections',
  'submission.comments.editComment' => 'Edit Comment',
  'submission.comments.importPeerReviews' => 'Import Peer Reviews',
  'submission.comments.addReviews' => 'Add Reviews to Email',
  'submission.comments.importPeerReviews.reviewerLetter' => 'Reviewer {$reviewerLetter}:',
  'submission.comments.noComments' => 'No Comments',
  'submission.comments.noReviews' => 'No Reviews',
  'submission.comments.review' => 'Review',
  'submission.comments.sendDecisionToReviewers' => 'Send Reviewers editorial decision',
  'submission.comments.subject' => 'Subject',
  'submission.complete' => 'Complete',
  'submission.contributors' => 'List of Contributors',
  'submission.copyedited' => 'Copyedited',
  'submission.copyediting' => 'Copyediting',
  'submission.queryNoteFiles' => 'Discussion Files',
  'submission.coverage' => 'Coverage Information',
  'submission.done' => 'Done',
  'submission.downloads' => 'Downloads',
  'submission.dueDate' => 'Due Date',
  'submission.due' => 'Due',
  'submission.editing' => 'Editing',
  'submission.editMetadata' => 'Edit Metadata',
  'submission.editorial' => 'Copyediting',
  'submission.email.backToEmailLog' => 'Back to Email Log',
  'submission.email.confirmClearLog' => 'Are you sure you want to clear the email log for this submission?',
  'submission.email.confirmDeleteLogEntry' => 'Are you sure you want to delete this email log entry?',
  'submission.email.deleteLogEntry' => 'Delete Log Entry',
  'submission.emailLog' => 'Email Log',
  'submission.event.participantAdded' => '{$name} ({$username}) was assigned to this submission as a {$userGroupName}.',
  'submission.event.participantRemoved' => '"{$name}" ({$username}) is removed as a {$userGroupName}.',
  'submission.event.backToEventLog' => 'Back to Event Log',
  'submission.event.confirmClearLog' => 'Are you sure you want to clear the event log for this submission?',
  'submission.event.confirmDeleteLogEntry' => 'Are you sure you want to delete this event log entry?',
  'submission.event.deleteLogEntry' => 'Delete Log Entry',
  'submission.event.submissionSubmitted' => 'Initial submission completed.',
  'submission.event.fileRevised' => 'Revision "{$name}" was uploaded for file {$submissionFileId}.',
  'submission.event.general.metadataUpdated' => 'Submission metadata updated',
  'submission.event.general.suppFileUpdated' => 'Submission file updated',
  'submission.event.reviewer.reviewAcceptedByProxy' => 'Review assignment accepted by proxy',
  'submission.event.reviewer.reviewAccepted' => 'Review assignment accepted',
  'submission.event.reviewer.reviewDeclined' => 'Review assignment declined',
  'submission.event.reviewer.reviewDueDate' => 'Review due date modified',
  'submission.event.reviewer.reviewerAssigned' => 'Reviewer assigned to submission',
  'submission.event.reviewer.reviewerRated' => 'Reviewer rating submitted',
  'submission.event.reviewer.reviewerUnassigned' => 'Reviewer unassigned from submission',
  'submission.event.reviewer.reviewFile' => 'Review file updated',
  'submission.event.reviewer.reviewInitiated' => 'Review assignment initiated',
  'submission.event.reviewer.reviewRecommendation' => 'Review recommendation file',
  'submission.event.reviewer.reviewReinitiated' => 'Review assignment reinitiated',
  'submission.event.reviewer.reviewResubmitted' => 'Review resubmitted',
  'submission.event.reviewer.reviewRevision' => 'Reviewer revisions file updated',
  'submission.event.subjectPrefix' => 'An email has been sent:',
  'submission.event.viewEmail' => 'View Email',
  'submission.event.addedStageToAllowedAuthorMetadataChange' => 'The authors are now allowed to edit metadata when submission in stage {stage}.',
  'submission.event.removedStageToAllowedAuthorMetadataChange' => 'The authors are now not allowed to edit metadata when submission in stage {stage}.',
  'submission.files' => 'Files',
  'submission.files.downloadAll' => 'Download All Files',
  'submission.file.notAllowedUploaderUserId' => 'A record of the file uploader is saved when the file is created and can not be changed.',
  'submission.firstPublished' => 'First published',
  'submission.galley' => 'Galley',
  'submission.history.clearLog' => 'Clear Log',
  'submission.history' => 'History',
  'submission.history.noLogEntries' => 'No log entries.',
  'submission.history.recentLogEntries' => 'Recent Entries',
  'submission.history.submissionEmailLog' => 'Email Log',
  'submission.history.submissionEventLog' => 'Event Log',
  'submission.history.submissionNotes' => 'Submission Notes',
  'submission.history.viewLog' => 'View Log',
  'submission.howToCite' => 'How to Cite',
  'submission.howToCite.citationFormats' => 'More Citation Formats',
  'submission.howToCite.downloadCitation' => 'Download Citation',
  'submission.initiated' => 'Initiated',
  'submission.updatedOn' => '{$datePublished} — Updated on {$dateUpdated}',
  'submission.versions' => 'Versions',
  'submission.versionIdentity' => '{$datePublished} ({$version})',
  'submission.outdatedVersion' => 'This is an outdated version published on {$datePublished}. Read the <a href="{$urlRecentVersion}">most recent version</a>.',
  'submission.identifiers' => 'Identifiers',
  'submission.publisherId' => 'Publisher ID',
  'submission.publisherId.description' => 'The publisher ID may be used to record the ID from an external database. For example, items exported for deposit to PubMed may include the publisher ID. This should not be used for DOIs.',
  'submission.publisherId.enable' => 'Enable for {$objects}',
  'submission.informationCenter.submissionInfo' => 'Submission Info',
  'submission.informationCenter.metadata' => 'Metadata',
  'submission.informationCenter.notes' => 'Notes',
  'submission.informationCenter.history' => 'History',
  'submission.informationCenter.history.allEvents' => 'Show events from prior versions',
  'submission.stageParticipants.notify' => 'Notify',
  'submission.lastModified' => 'Last modified',
  'submission.layout.addGalley' => 'Add a Layout Galley',
  'submission.layout.confirmDeleteGalley' => 'Are you sure you want to permanently delete this galley?',
  'submission.layout.confirmDeleteGalleyImage' => 'Are you sure you want to remove this image from the galley?',
  'submission.layout.deleteGalleyStylesheet' => 'Delete this style sheet.',
  'submission.layout.editGalley' => 'Edit a Layout Galley',
  'submission.layout.galleyFormat' => 'Galley Format',
  'submission.layout.galleyHTMLData' => 'HTML Galley Files',
  'submission.layout.galleyImages' => 'Images',
  'submission.layout.galleyLabel' => 'Galley Label',
  'submission.layout.galleyLabelInstructions' => 'Typically used to identify the file format (e.g. PDF, HTML, etc.).',
  'submission.layout.galleyLabelRequired' => 'A galley label is required.',
  'submission.layout.galleyLanguageRequired' => 'A galley language is required.',
  'submission.layout.galleyLocaleRequired' => 'A galley locale is required.',
  'submission.layout.galleyRemoteURL' => 'Remote URL',
  'submission.layout.galleyRemoteURLValid' => 'Please provide a valid remote URL (include http://).',
  'submission.layout.galleyNoImages' => 'No images',
  'submission.layout.galleys' => 'Galleys',
  'submission.layout.galleyStylesheet' => 'Stylesheet File',
  'submission.layout.galleyStyle' => 'Style',
  'submission.layout.initialGalleyCreation' => 'Initial Galley Creation',
  'submission.layout.layoutFile' => 'Layout File',
  'submission.layout' => 'Layout',
  'submission.layout.layoutVersion' => 'Layout Version',
  'submission.layout.newGalley' => 'Create New Galley',
  'submission.layout.noStyleFile' => 'No style sheet file has been added to this galley.',
  'submission.layout.viewingGalley' => 'Viewing Submission Galley',
  'submission.layout.viewProof' => 'View Proof',
  'submission.metadata' => 'Submission Metadata',
  'submission.noReviewAssignments' => 'No Review Assignments',
  'submission.notes.addNewNote' => 'Add New Note',
  'submission.notes.attachedFile' => 'File Attachment',
  'submission.notes.backToSubmissionNotes' => 'Back To Submission Notes',
  'submission.notes.breadcrumb' => 'Notes',
  'submission.notes.clearAllNotes' => 'Clear All Notes',
  'submission.notes.collapseNotes' => 'Collapse Notes',
  'submission.notes.confirmDeleteAll' => 'Remove All Submission Notes?',
  'submission.notes.confirmDelete' => 'Remove This Submission Note?',
  'submission.notes.createNewNote' => 'Create New Note',
  'submission.notes.deleteNote' => 'Delete Note',
  'submission.notes.editNote' => 'Edit Note',
  'submission.notes.expandNotes' => 'Expand Notes',
  'submission.notes.noSubmissionNotes' => 'No Submission Notes',
  'submission.notes.removeUploadedFile' => 'Remove Uploaded File',
  'submission.notes' => 'Submission Notes',
  'submission.notes.updateNote' => 'Update Note',
  'submission.notes.viewNotes' => 'View Notes',
  'submission.originalFile' => 'Original file',
  'submission.page.editing' => '#{$id} Editing',
  'submission.page.history' => '#{$id} History',
  'submission.page.review' => '#{$id} Review',
  'submission.page.summary' => '#{$id} Summary',
  'submission.page.citations' => '#{$id} Citations',
  'submission.peerReview' => 'Peer&nbsp;Review',
  'submission.production' => 'Production',
  'submission.recommendation' => 'Recommendation: {$recommendation}',
  'submission.rejected' => 'Rejected',
  'submission.request' => 'Request',
  'submission.response' => 'Response',
  'submission.restrictions' => 'Restrictions',
  'submission.reviewMetadata' => 'Review Metadata',
  'submission.review' => 'Review',
  'submission.reviewed' => 'Reviewed',
  'submission.reviewVersion' => 'Review Version',
  'submission.rights' => 'Rights',
  'submission.rights.tip' => 'If you wish, you may enter a brief statement about the access rights held in or over this submission.',
  'submissions.active' => 'Active',
  'submissions.archived' => 'Archived',
  'submission.saveMetadata' => 'Save Metadata',
  'submissions.completed' => 'Completed',
  'submissions.declined' => 'Declined',
  'submissions.incomplete' => 'Incomplete',
  'submissions.noSubmissions' => 'No Submissions',
  'submissions.queuedEditing' => 'In Editing',
  'submissions.queued' => 'Queued',
  'submissions.queuedUnassigned' => 'No editor has been assigned to this submission.',
  'submissions.ruling' => 'Ruling',
  'submission.source' => 'Source',
  'submission.source.tip' => 'Is this submission derived from another resource? If so, you may enter a URL or description of that resource.',
  'submissions.submit' => 'Submit',
  'submissions.submitted' => 'Submitted',
  'submission.submission' => 'Submission',
  'submission.submissionTitle' => 'Submission Title:',
  'submission.start' => 'Start',
  'submission.submissionHistory' => 'Submission History',
  'submission.submissionManuscript' => 'Submission Manuscript',
  'submission.submissionReview' => 'Submission Review',
  'submission.submitter' => 'Submitter',
  'submission.submit.finishSubmission' => 'Finish Submission',
  'submission.submit.selectFile' => 'Select File',
  'submission.submit.fileInformation' => 'File Information',
  'submission.submit.fileAdded' => 'File Added',
  'submission.submit.includeInBrowse' => 'Include this contributor in browse lists?',
  'submission.submit.newFile' => 'Add Another File',
  'submission.submit.metadataForm' => 'Additional Refinements',
  'submission.submit.metadataForm.tip' => 'Add additional information for your submission.  Press \'enter\' after each term.',
  'submission.submit.submissionLocale' => 'Submission Language',
  'submission.submit.submissionLocaleDescription' => 'Submissions in several languages are accepted. Choose the primary language of the submission from the pulldown above.',
  'submission.submit.submissionFiles' => 'Submission Files',
  'submission.submit.dependentFiles' => 'Dependent Files',
  'submission.manageDependentFiles' => 'Manage Dependent Files',
  'submission.upload.instructions' => 'Upload any files the editorial team will need to evaluate your submission.',
  'submission.upload.percentComplete' => 'Uploading {$percent}% complete',
  'submission.upload.dependent' => 'Upload a Dependent File',
  'submission.upload.query' => 'Upload a Discussion File',
  'submission.summary' => 'Summary',
  'submission.supportingAgencies' => 'Supporting Agencies',
  'submission.currentAgencies' => 'Current Agencies',
  'submission.indexingInformation' => 'Indexing Information',
  'submission.titleAndAbstract' => 'Title and Abstract',
  'submission.type.tip' => 'The submission type is usually one of \'image\', \'text\', or other multimedia types including \'software\' or \'interactive\'.  Please choose the one most relevant for your submission.  Examples may be found at <a target="_blank" href="http://dublincore.org/documents/2001/04/12/usageguide/generic.shtml#type">http://dublincore.org/documents/2001/04/12/usageguide/generic.shtml#type</a>',
  'submission.underway' => 'Underway',
  'submission.uploadFileTo' => 'Upload file to',
  'submission.createRemote' => 'Create remote',
  'submission.viewMetadata' => 'View Metadata',
  'submission.views' => 'Views',
  'submission.uploadSuccessful' => 'Your file has been uploaded.',
  'submission.loadMessage' => 'Please wait while your file is uploaded to the server.',
  'submission.artworkFileDetails' => 'Artwork File Details',
  'submission.fileDetails' => 'File Details',
  'submission.nameRequired' => 'A name is required for this item.',
  'submission.date.mmdd' => 'MM-DD',
  'submission.date.yyyymmdd' => 'YYYY-MM-DD',
  'submission.submit.selectPrincipalContact' => 'Principal contact for editorial correspondence.',
  'submission.submit.contributorRole' => 'Contributor\'s role',
  'submission.submit.addAuthor' => 'Add Contributor',
  'submission.submit.form.languagesRequired' => 'Please enter a language.',
  'submission.submit.form.subjectsRequired' => 'Please enter a subject.',
  'submission.submit.form.disciplinesRequired' => 'Please enter a discipline.',
  'submission.submit.form.keywordsRequired' => 'Please enter a keyword.',
  'submission.submit.form.coverageRequired' => 'Please enter the coverage information.',
  'submission.submit.form.typeRequired' => 'Please enter the type.',
  'submission.submit.form.sourceRequired' => 'Please enter the source.',
  'submission.submit.form.rightsRequired' => 'Please enter the rights.',
  'submission.submit.form.citationsRequired' => 'Please enter the references.',
  'submission.form.name' => 'Name the file (e.g., Manuscript; Table 1)',
  'submission.form.replaceExisting' => 'Replacing an Existing File?',
  'workflow.review.internalReview' => 'Internal Review',
  'workflow.stage.any' => 'Any Stage',
  'workflow.stage' => 'Stage',
  'submission.status.editorial' => 'In Copyediting',
  'submission.status.production' => 'In Proofreading',
  'submission.status.review' => 'In Review',
  'submission.status.submission' => 'Awaiting Editor Decision',
  'submission.status.unassigned' => 'Unassigned',
  'submission.status.declined' => 'Declined',
  'submission.status.published' => 'Published',
  'submission.submit.uploadStep' => '1. Upload File',
  'submission.submit.uploadSubmissionFile' => 'Upload Submission File',
  'submission.submit.metadataStep' => '2. Review Details',
  'submission.submit.finishingUpStep' => '3. Confirm',
  'submission.submit.fileNameRequired' => 'You must enter a file name for this file',
  'submission.upload.noGenre' => 'Missing or invalid component!',
  'submission.upload.invalidUserGroup' => 'Missing or invalid user group!',
  'submission.upload.possibleRevision' => 'Possible Duplication or Revision Detected',
  'submission.upload.possibleRevisionDescription' => 'The name of the uploaded file resembles the name of a previously uploaded file, "{$revisedFileName}." Is this file intended to replace "{$revisedFileName}"? If so, select the file below. Otherwise, select "This is not a revision of an existing file" before proceeding.',
  'submission.upload.selectMandatoryFileToRevise' => 'Please select the file you would like to revise.',
  'submission.upload.selectOptionalFileToRevise' => 'If you are uploading a revision of an existing file, please indicate which file.',
  'submission.upload.uploadNewFile' => 'This is not a revision of an existing file',
  'submission.upload.userGroup' => 'Upload this file in my role as...',
  'submission.upload.userGroupDescription' => 'If you are submitting an Edited Volume, you should upload all volume chapters individually, under your role as volume editor.',
  'submission.upload.uploadLibraryFile' => 'Upload a Library File',
  'submission.upload.libraryCategory' => 'Submission Document Category',
  'submission.upload.finalDraft' => 'Upload File',
  'submission.upload.copyeditedVersion' => 'Upload Copyedited File',
  'submission.upload.uploadFiles' => 'Upload Files',
  'submission.upload.response.description' => 'After reviewing the assigned file, record any comments on the file below, and/or upload an annotated copy of the file (or another file).',
  'submission.upload.productionReady' => 'Upload a Production Ready File',
  'submission.upload.proof' => 'Upload a File Ready for Publication',
  'submission.upload.noAvailableReviewFiles' => 'There are no files for you to revise at this time.',
  'editor.submission.roundStatus.revisionsRequested' => 'Revisions have been requested.',
  'editor.submission.roundStatus.revisionsSubmitted' => 'Revisions have been submitted.',
  'editor.submission.roundStatus.resubmitForReview' => 'The submission must be resubmitted for another review round.',
  'editor.submission.roundStatus.submissionResubmitted' => 'Submission has been resubmitted for another review round.',
  'editor.submission.roundStatus.sentToExternal' => 'Sent to external review.',
  'editor.submission.roundStatus.accepted' => 'Submission accepted.',
  'editor.submission.roundStatus.declined' => 'Submission declined.',
  'editor.submission.roundStatus.pendingReviewers' => 'Waiting for reviewers to be assigned.',
  'editor.submission.roundStatus.pendingReviews' => 'Awaiting responses from reviewers.',
  'editor.submission.roundStatus.reviewsReady' => 'New reviews have been submitted.',
  'editor.submission.roundStatus.reviewsCompleted' => 'All reviewers have responded and a decision is needed.',
  'editor.submission.roundStatus.reviewOverdue' => 'A review is overdue.',
  'editor.submission.roundStatus.pendingRecommendations' => 'Awaiting recommendations from editors.',
  'editor.submission.roundStatus.recommendationsReady' => 'New editorial recommendations have been submitted.',
  'editor.submission.roundStatus.recommendationsCompleted' => 'All recommendations are in and a decision is needed.',
  'editor.submission.stageParticipants' => 'Participants',
  'editor.submission.noneAssigned' => 'None Assigned',
  'editor.submission.participant' => 'Participant',
  'editor.submission.addStageParticipant' => 'Assign Participant',
  'editor.submission.editStageParticipant' => 'Edit Assignment',
  'editor.submission.addStageParticipant.userGroup' => 'Users are assigned to stages of the workflow by user group. Any user assigned to this stage will automatically be assigned to other stages to which their user group has been assigned. This is commonly reserved for editors, authors and translators.',
  'editor.submission.removeStageParticipant' => 'Remove Participant',
  'editor.submission.removeStageParticipant.description' => 'You are about to remove this participant from <strong>all</strong> stages.',
  'editor.submission.addStageParticipant.form.userGroupRequired' => 'You must select a user group.',
  'editor.submission.addStageParticipant.form.userRequired' => 'You must select a user for the specified user group.',
  'editor.submission.addStageParticipant.form.reviewerWarning' => 'The participant you selected has been assigned to conduct an anonymous review. If you assign them as a participant, they will have access to the author\'s identity. You are encouraged not to assign this participant unless you can independently ensure the integrity of the peer review process.',
  'editor.submission.removePermissionToEdit' => 'Disallow Edit Metadata',
  'editor.submission.addPermissionToEdit' => 'Allow Edit Metadata',
  'editor.submission.removePermissionToEditDescription' => 'Are you sure you want the authors of this submission to be unable to edit the submission\'s metadata at that stage?',
  'editor.submission.addPermissionToEditDescription' => 'Are you sure you want the authors of this submission to be able to edit the submission\'s metadata at that stage?',
  'editor.submission.decision' => 'Decision',
  'editor.submission.decision.accept' => 'Accept Submission',
  'editor.submission.decision.requestRevisions' => 'Request Revisions',
  'editor.submission.decision.resubmit' => 'Resubmit for Review',
  'editor.submission.decision.newRound' => 'New review round',
  'editor.submission.decision.decline' => 'Decline Submission',
  'editor.submission.decision.sendToProduction' => 'Send To Production',
  'editor.submission.decision.skipReview' => 'Accept and Skip Review',
  'editor.submission.decision.sendInternalReview' => 'Send to Internal Review',
  'editor.submission.decision.approveProofsDescription' => 'The page proof file must be checked as approved to be made Available. Do you want to approve it?',
  'editor.submission.decision.approveProofs' => 'Approve Proofs',
  'editor.submission.decision.disapproveProofsDescription' => 'This file proof will no longer be publicly available for download or purchase. Do you want to disapprove it?',
  'editor.submission.decision.revertDecline' => 'Revert Decline',
  'editor.submission.decision.noDecisionsAvailable' => 'Assign an editor to enable the editorial decisions for this stage.',
  'editor.submission.makeRecommendation' => 'Make Recommendation',
  'editor.submission.changeRecommendation' => 'Change Recommendation',
  'editor.submission.recommendation.display' => 'Recommendation: {$recommendation}',
  'editor.submission.allRecommendations.display' => 'Recommendations: {$recommendations}',
  'editor.submission.recommendation' => 'Recommendation',
  'editor.submission.recommendation.description' => 'Recommend an editorial decision for this submission.',
  'editor.submission.recordedRecommendations' => 'Recorded Recommendations',
  'editor.submission.decision.nextButton' => 'Next: Select Files for {$stageName}',
  'editor.submission.decision.selectFiles' => 'Select the files you would like to forward to the {$stageName} stage.',
  'editor.submission.decision.previousAuthorNotification' => 'Previous: Author Notification',
  'submission.currentStage' => 'Current stage',
  'submission.noActionRequired' => 'No action required',
  'submission.actionNeeded' => 'Needs action',
  'reviewer.submission.reviewFiles' => 'Review Files',
  'submission.submit.currentFile' => 'Current file',
  'submission.finalDraft' => 'Draft Files',
  'editor.submission.addAuditorError' => 'There was an error trying to assign the auditor. Please Try again.',
  'submission.event.fileEdited' => 'The metadata for file "{$originalFileName}" was edited by {$username}.',
  'submission.event.fileUploaded' => 'A file "{$originalFileName}" was uploaded for submission {$submissionId} by {$username}.',
  'submission.event.fileDeleted' => 'A file "{$originalFileName}" was deleted for submission {$submissionId} by {$username}.',
  'submission.event.revisionUploaded' => 'A file revision "{$originalFileName}" was uploaded for submission {$submissionId} by {$username}.',
  'submission.event.revisionDeleted' => 'A file revision "{$originalFileName}" was deleted for submission {$submissionId} by {$username}.',
  'submission.event.lastRevisionDeleted' => 'A file "{$title}" had its last revision removed by {$username}.',
  'submission.event.fileAuditorAdded' => '"{$name}" ({$username}) was added as an auditor for the file "{$file}."',
  'submission.event.fileAuditorCleared' => '"{$name}" ({$username}) was removed as an auditor for the file "{$file}."',
  'submission.event.fileAuditUploaded' => '"{$name}" ({$username}) has completed an audit and uploaded "{$file}."',
  'submission.event.signoffSignoff' => '"{$name}" ({$username}) has signed off on the signoff for "{$file}."',
  'submission.event.proofsApproved' => '"{$name}" ({$username}) has approved the proofs for "{$formatName}."',
  'submission.overview' => 'Submission Overview',
  'submission.description' => 'Description',
  'submission.stageNotInitiated' => 'Stage not initiated.',
  'submission.documents' => 'Submission Documents',
  'notification.type.editorAssign' => 'You have been assigned as an editor to the submission "{$title}".',
  'notification.type.copyeditorRequest' => 'You have been asked to review copyedits for "{$title}".',
  'notification.type.layouteditorRequest' => 'You have been asked to review layouts for "{$title}".',
  'notification.type.indexRequest' => 'You have been asked to create an index for "{$title}".',
  'notification.type.editorDecisionTitle' => 'Latest editor decision.',
  'notification.type.editorDecisionAccept' => 'Submission accepted.',
  'notification.type.editorDecisionExternalReview' => 'External review process started.',
  'notification.type.editorDecisionPendingRevisions' => 'Revision required.',
  'notification.type.editorDecisionResubmit' => 'Resubmit for review.',
  'notification.type.editorDecisionNewRound' => 'A new round of reviews was initiated.',
  'notification.type.editorDecisionDecline' => 'Submission declined.',
  'notification.type.editorDecisionRevertDecline' => 'Declined submission reactivated.',
  'notification.uploadedResponse' => 'Response uploaded.',
  'notification.type.editorAssignment' => 'An editor must be assigned before review is initiated. Please add editor using the Participants list.',
  'notification.type.submissionNewVersion' => 'A new version of a submission was created',
  'notification.type.revertDecline' => 'The decision to decline this submission was reverted.',
  'grid.reviewAttachments.title' => 'Reviewer\'s Attachments',
  'grid.reviewAttachments.send.title' => 'Select review files to share with the author(s)',
  'submission.productionReady' => 'Book available',
  'submission.review.uploadRevisionToRound' => 'Upload Revised File',
  'log.review.reviewerAssigned' => '{$reviewerName} has been assigned to review submission {$submissionId} for review round {$round}.',
  'log.review.reviewCleared' => 'The round {$round} review by {$reviewerName} for submission {$submissionId} has been cleared.',
  'log.review.reviewUnconsidered' => '{$editorName} has marked the round {$round} review for submission {$submissionId} as unconsidered.',
  'log.review.reviewReinstated' => 'The round {$round} review by {$reviewerName} for submission {$submissionId} has been reinitiated.',
  'log.review.reviewConfirmed' => 'Editor {$userName} has confirmed a review for the round {$round} review for submission {$submissionId}.',
  'log.review.reviewReady' => '{$reviewerName} has completed the review for the round {$round} review for submission {$submissionId}.',
  'submission.review.status.awaitingResponse' => 'Waiting for a response from the reviewer.',
  'submission.review.status.declined' => 'The reviewer declined this review request.',
  'submission.review.status.responseOverdue' => 'The reviewer has missed the response due date.',
  'submission.review.status.reviewOverdue' => 'The reviewer has missed the review due date.',
  'submission.review.status.accepted' => 'This review has been accepted.',
  'submission.review.status.received' => 'The reviewer has submitted their review.',
  'submission.review.status.complete' => 'This review has been completed.',
  'submission.review.status.thanked' => 'This review is complete and the reviewer has been thanked for their contribution.',
  'submission.document' => 'Document',
  'submission.art' => 'Artwork',
  'submission.supplementary' => 'Supplementary Content',
  'submission.supplementary.creator' => 'Creator (or owner) of file',
  'submission.supplementary.subject' => 'Subject',
  'submission.supplementary.publisher' => 'Publisher',
  'submission.supplementary.sponsor' => 'Contributor or sponsoring agency',
  'grid.action.itemWorkflow' => 'Go to this submission\'s workflow',
  'notification.type.editorDecisionSendToProduction' => 'Production process started.',
  'notification.type.editorAssignmentProduction' => 'A production editor must be assigned before production process can be initiated. Please add a production editor using the Participants list.',
  'notification.type.editorAssignmentEditing' => 'A production editor must be assigned before editorial process is initiated. Please add a production editor using the Participants list.',
  'submission.reviewForm' => 'Review Form',
  'submission.reviewFormResponse' => 'Review Form Response',
  'grid.action.createReviewFormElement' => 'Create a new review form element',
  'grid.action.editMetadata' => 'Edit Metadata',
  'submission.permissions' => 'Permissions',
  'submission.attachPermissions' => 'Attach the following permissions to the submission:',
  'submission.license' => 'License',
  'submission.copyright' => 'Copyright',
  'submission.copyrightHolder' => 'Copyright Holder',
  'submission.copyrightHolder.other' => 'Custom copyright statement',
  'submission.copyrightOther' => 'Copyright statement',
  'submission.copyrightYear' => 'Copyright Year',
  'submission.copyrightStatement' => 'Copyright (c) {$copyrightYear} {$copyrightHolder}',
  'submission.licenseURLValid' => 'Please provide a valid remote URL (include http://).',
  'submission.licenseURL' => 'License URL',
  'submission.license.cc.by-nc-nd4' => 'CC Attribution-NonCommercial-NoDerivatives 4.0',
  'submission.license.cc.by-nc4' => 'CC Attribution-NonCommercial 4.0',
  'submission.license.cc.by-nc-sa4' => 'CC Attribution-NonCommercial-ShareAlike 4.0',
  'submission.license.cc.by-nd4' => 'CC Attribution-NoDerivatives 4.0',
  'submission.license.cc.by4' => 'CC Attribution 4.0',
  'submission.license.cc.by-sa4' => 'CC Attribution-ShareAlike 4.0',
  'submission.license.cc.by-nc-nd4.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nc-nd/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc-nd/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a>.</p>',
  'submission.license.cc.by-nc4.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nc/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a>.</p>',
  'submission.license.cc.by-nc-sa4.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.</p>',
  'submission.license.cc.by-nd4.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nd/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nd/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nd/4.0/">Creative Commons Attribution-NoDerivatives 4.0 International License</a>.</p>',
  'submission.license.cc.by4.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.</p>',
  'submission.license.cc.by-sa4.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-sa/4.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.</p>',
  'submission.license.cc.by-nc-nd3.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nc-nd/3.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc-nd/3.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc-nd/3.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 3.0 Unported License</a>.</p>',
  'submission.license.cc.by-nc3.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nc/3.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc/3.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc/3.0/">Creative Commons Attribution-NonCommercial 3.0 Unported License</a>.</p>',
  'submission.license.cc.by-nc-sa3.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/3.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nc-sa/3.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/3.0/">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>.</p>',
  'submission.license.cc.by-nd3.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-nd/3.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-nd/3.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nd/3.0/">Creative Commons Attribution-NoDerivatives 3.0 Unported License</a>.</p>',
  'submission.license.cc.by3.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by/3.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by/3.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution 3.0 Unported License</a>.</p>',
  'submission.license.cc.by-sa3.footer' => '<a rel="license" href="https://creativecommons.org/licenses/by-sa/3.0/"><img alt="Creative Commons License" src="//i.creativecommons.org/l/by-sa/3.0/88x31.png" /></a><p>This work is licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-sa/3.0/">Creative Commons Attribution-ShareAlike 3.0 Unported License</a>.</p>',
  'submission.queries.submission' => 'Pre-Review Discussions',
  'submission.queries.review' => 'Review Discussions',
  'submission.queries.editorial' => 'Copyediting Discussions',
  'submission.query.subject' => 'Subject',
  'submission.query.messages' => 'Messages',
  'submission.query.replies' => 'Replies',
  'submission.query.from' => 'From',
  'submission.query.lastReply' => 'Last Reply',
  'submission.query.closed' => 'Closed',
  'submission.query.addNote' => 'Add Message',
  'submission.query.leaveQuery' => 'Leave Discussion',
  'submission.query.leaveQuery.confirm' => 'If you leave this discussion you will no longer be notified of new messages. Would you like to leave the discussion?',
  'grid.action.openNoteForm' => 'Add a new reply to the discussion',
  'submission.query.activity' => '{$responderName} replied to {$noteTitle}: {$noteContents}',
  'submission.query.new' => '{$creatorName} started a discussion: {$noteTitle}: {$noteContents}',
  'submission.query.activity.contents' => 'There is new activity in the discussion titled "{$queryTitle}" regarding the submission "{$submissionTitle}".',
  'submission.query.new.contents' => 'You have been added to a discussion titled "{$queryTitle}" regarding the submission "{$submissionTitle}".',
  'submission.query.participantTitle' => '{$fullName}, {$userGroup}',
  'submission.query.noParticipantOptions' => 'You must assign at least one participant to this submission before initiating a discussion.',
  'submission.list.infoCenter' => 'Activity Log & Notes',
  'submission.list.empty' => 'No submissions found.',
  'submission.list.responseDue' => 'Response Due: {$date}',
  'submission.list.reviewAssignment' => 'Review Assignment',
  'submission.list.reviewDue' => 'Review Due: {$date}',
  'submission.list.reviewComplete' => 'Review Submitted',
  'submission.list.reviewCancelled' => 'Review Cancelled',
  'submission.list.confirmDelete' => 'Delete submission?',
  'submission.list.viewSubmission' => 'View Submission',
  'submission.list.reviewsCompleted' => 'Assigned reviews completed',
  'submission.list.revisionsSubmitted' => 'Revisions submitted',
  'submission.list.copyeditsSubmitted' => 'Copyedited files submitted',
  'submission.list.galleysCreated' => 'Production galleys created',
  'submission.list.filesPrepared' => 'Files prepared',
  'submission.list.discussions' => 'Open discussions',
  'submission.list.dualWorkflowLinks' => 'You have been assigned multiple roles for this submission. Would you like to access the <a href="{$urlAuthorWorkflow}">Author\'s workflow</a>  or the <a href="{$urlEditorialWorkflow}">Editorial workflow</a>?',
  'submission.list.reviewerWorkflowLink' => 'You have been assigned an editorial role for this submission. Would you like to access the <a href="{$urlEditorialWorkflow}">Editorial workflow</a>?',
  'submission.list.incompleteSubmissionNotice' => 'This submission must be completed before an editor will review it.',
  'submission.list.currentStage' => 'Currently in the {$stage} stage.',
  'submission.list.activity' => 'Activity',
  'submission.list.daysSinceLastActivity' => 'Days since last activity',
  'submission.list.assignEditor' => 'Assign Editor',
  'grid.category.categories' => 'Categories',
  'catalog.sortBy.titleAsc' => 'Title (A-Z)',
  'catalog.sortBy.titleDesc' => 'Title (Z-A)',
  'catalog.sortBy.datePublishedAsc' => 'Publication date (oldest first)',
  'catalog.sortBy.datePublishedDesc' => 'Publication date (newest first)',
  'category.coverImage' => 'Cover Image',
  'submission.submit.placement.categories' => 'Categories',
  'submission.currentCoverImage' => 'Current Image',
  'catalog.category.noItems' => 'Nothing has been published in this category yet.',
  'catalog.category.subcategories' => 'Subcategories',
  'publication.contributors' => 'Contributors',
  'publication.createVersion' => 'Create New Version',
  'publication.datePublished.errorFormat' => 'The date must be in the format YYYY-MM-DD, such as 2019-01-01.',
  'publication.event.versionCreated' => 'A new version was created.',
  'publication.publicationLicense' => 'Permissions & Disclosure',
  'publication.status.scheduled' => 'Scheduled',
  'publication.status.unpublished' => 'Unpublished',
  'publication.titleAbstract' => 'Title & Abstract',
  'publication.unschedule' => 'Unschedule',
  'publication.urlPath' => 'URL Path',
  'publication.urlPath.description' => 'An optional path to use in the URL instead of the ID.',
  'publication.urlPath.duplicate' => 'The URL path has already been used and can not be used again.',
  'publication.urlPath.numberInvalid' => 'The URL path can not be a number.',
  'publication.version.all' => 'All Versions',
  'publication.version.confirm' => 'Are you sure you want to create a new version?',
  'publication.wordCountLong' => 'The abstract is too long. It shoud be {$limit} words or less. It is currently {$count} words long.',
  'publication.wordCount' => 'Word Count: {$count}/{$limit}',
  'submission.layout.viewGalley' => 'View Galley',
  'galley.cantEditPublished' => 'This galley can not be edited because it has already been published.',
  'author.competingInterests' => 'Competing Interests',
  'author.competingInterests.description' => 'Please disclose any competing interests this author may have with the research subject.',
);